<?php

/**
 * Theme functions and definitions
 *
 * @package HelloElementorChild
 */

/**
 * Load child theme css and optional scripts
 *
 * @return void
 */
function hello_elementor_child_enqueue_scripts()
{
	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		'1.0.0'
	);
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_scripts', 20);

add_filter('big_image_size_threshold', '__return_false');

// Desabilitar icones FontAwesome
add_action('elementor/frontend/after_register_styles',function() {
	foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
		wp_deregister_style( 'elementor-icons-fa-' . $style );
	}
}, 20 );
// Força a remoção dos icones do FontAwesome
add_action( 'wp_print_styles', 'tn_dequeue_font_awesome_style' );
function tn_dequeue_font_awesome_style() {
	wp_dequeue_style( 'fontawesome' );
	wp_deregister_style( 'fontawesome' );
}
// Desabilitar Google fonts
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );

if ( !is_user_logged_in() ) {
	// Desabilitar icones do Elementor apenas quando não esta logado!
	add_action( 'wp_enqueue_scripts', 'remove_default_stylesheet', 20 ); 
	function remove_default_stylesheet() { 
		wp_deregister_style( 'elementor-icons' ); 
	}

	//Desabilitar Gutenberg
	function smartwp_remove_wp_block_library_css(){
		wp_dequeue_style( 'wp-block-library' );
		wp_dequeue_style( 'wp-block-library-theme' );
		wp_dequeue_style( 'wc-blocks-style' ); // Remover Bloco de Css para WooCommerce
	} 
	add_action( 'wp_enqueue_scripts', 'smartwp_remove_wp_block_library_css', 100 );
}